//==========================================
// Bottles to be used with frige.pov
//==========================================
// Copyright(c) Gilles Tran 2001            
// http://www.oyonale.com
// Feel free to use and modify
//==========================================
// Made for Persistence of vision 3.5
//==========================================  

//------------------------------------------
// Textures
//------------------------------------------
#declare sc=0.9;
#declare fSeaGreen = rgbf <0.137255*sc,0.556863*sc,0.419608*sc,1>;
#declare fMediumSeaGreen = rgbf <0.258824,0.435294,0.258824,1>;
#declare txtBouteille1=material{
        texture{
                gradient y
                texture_map{
                        [0.8 pigment{fSeaGreen} finish {ambient 0 diffuse 0.8 specular 1 roughness 0.0001 reflection 0.2}]
                        [0.8 pigment{image_map{jpeg "winelabel.jpg" map_type 2} scale <0.2,-0.2,0.2>} finish{ambient 0.3 diffuse 0.8 specular 0.1 roughness 0.1}]
                }
                translate -y*0.4
        }       
        rotate y*180
//        interior{ior 1.4}
}        
#declare txtLiquide1=material{
        texture{pigment{rgbf<1,0.1,0.1,1>} finish {ambient 0 diffuse 0.8 specular 1 roughness 0.001}}
//        interior{ior 1.3}
}        
#declare txtBouteille2=material{
        texture{
                gradient y
                texture_map{
                        [0.8 pigment{fMediumSeaGreen} finish {ambient 0 diffuse 0.8 specular 1 roughness 0.0001 reflection 0.2}]
                        [0.8 pigment{image_map{jpeg "swisslabel.jpg" map_type 2} scale <0.2,-0.2,0.2> } finish{ambient 0.3 diffuse 0.8 specular 0.1 roughness 0.1}]
                }
                translate -y*0.3
        }
        interior{ior 1.4}
}        
#declare txtLiquide2=material{
        texture{pigment{rgbf<1,0.5,0.1,1>} finish {ambient 0 diffuse 0.8 specular 1 roughness 0.001}}
        interior{ior 1.3}
}        
#declare txtBouteille3=material{
        texture{
                gradient y
                texture_map{
                        [0.8 pigment{rgbf<0.89,1,1,1>} finish {ambient 0 diffuse 0.8 specular 1 roughness 0.0001 reflection 0.2}]
                        [0.8 pigment{image_map{jpeg "waterlabel.jpg" map_type 2} scale <0.2,-0.2,0.2>} finish{ambient 0.3 diffuse 0.8 specular 0.1 roughness 0.1}]
                }
                translate -y*0.3
        }
        interior{ior 1.4}
}        
#declare txtLiquide3=material{
        texture{pigment{rgbf<0.99,1,1,1>} finish {ambient 0 diffuse 0.8 specular 1 roughness 0.001}}
        interior{ior 1.3}
}        
#declare txtBouteille4=material{
        texture{pigment{rgbf<0.9,0.9,0.9,1>} finish {ambient 0 diffuse 0.8 specular 1 roughness 0.001}}
        interior{ior 1.3}
}        
#declare txtLiquide4=material{
        texture{pigment{rgbf<1*1.2,0.5*1.2,0.1*1.2,1>} finish {ambient 0 diffuse 1 specular 1 roughness 0.001}}
        interior{ior 1.3}
}        
#declare txtEtiquetteBouteille4=texture{
        pigment{image_map{jpeg "affligem.jpg"}}
        finish{ambient 0.3 diffuse 0.8 specular 0.1 roughness 0.1}
        translate <-0.5,-0.5,0>
        scale 2*0.08*<1,-1,1>
        translate y*0.38
        
}

#declare colBouchon=rgb<0.8,0.7,0.4>*1.5;
#declare txtBouchon=texture{
        pigment{
                dents
                color_map{
                        [0.3 colBouchon]
                        [0.3 colBouchon*0.3]
                }
        }
        finish{  
                ambient 0 diffuse 1 specular 0.8 roughness 0.1
        }
        scale 0.1
}         
//------------------------------------------
// Cork
//------------------------------------------
#declare Bouchon=cylinder{-y*1,y*3,1 texture{txtBouchon}}
#declare Bouchon=isosurface{
        function{x*x+z*z-1.3 +f_noise3d(x,y,z)*0.7}
        contained_by{box{<-1,-2,-1>,<1,3,1>}}
        texture{txtBouchon}
}

//------------------------------------------
// plastic cork
//------------------------------------------
#declare txtBouchon2=texture{pigment{rgbf<1,1,1,0.5>} finish{ambient 0 diffuse 1 specular 1 roughness 0.001}}
#declare Bouchon2=union{
        torus{1,0.3 scale <1,0.5,1> translate -y}
        difference{
                cylinder{-y*1,y*1,1.3}
                #declare i=0;
                #while (i<360)          
                        cylinder{-y*0.5,y*1,0.1 translate x*1.3 rotate y*i}
                        #declare i=i+10;
                #end 
        }
        scale <1.3,1,1.3>
        texture{txtBouchon2}
        }
#declare txtBouchon4=texture{pigment{Gold*1.5} finish{ambient 0 diffuse 1 specular 1 roughness 0.03 metallic brilliance 5 reflection 0.2}}
#declare Bouchon4=union{
        torus{1,0.3 scale <1,0.5,1> translate -y}
        difference{
                cylinder{-y*1,y*1,1.3}
                #declare i=0;
                #while (i<360)          
                        cylinder{-y*0.5,y*1,0.1 translate x*1.3 rotate y*i}
                        #declare i=i+30;
                #end 
        }
        scale <1.2,0.8,1.2>
        texture{txtBouchon4}
        }
//------------------------------------------
// Bottle 1
//------------------------------------------
#declare Bouteille1=union{
    lathe{
    	cubic_spline
    	26,
    	<0.038000,0.040000>,
    	<0.032000,0.024000>,
    	<0.040000,0.004000>,
    	<0.051000,0.013000>,
    	<0.046000,0.023000>,
    	<0.050000,0.040000>,
    	<0.041000,0.065000>,
    	<0.050000,0.230000>,
    	<0.090000,0.300000>,
    	<0.100000,0.380000>,
    	<0.100000,0.480000>,
    	<0.100000,0.730000>,
    	<0.070000,0.760000>,
    	<0.040000,0.760000>,
    	<0.010000,0.720000>,
    	<0.040000,0.750000>,
    	<0.070000,0.750000>,
    	<0.090000,0.730000>,
    	<0.090000,0.480000>,
    	<0.090000,0.380000>,
    	<0.080000,0.300000>,
    	<0.040000,0.230000>,
    	<0.030000,0.054000>,
    	<0.038000,0.040000>,
    	<0.032000,0.024000>,
    	<0.040000,0.004000>
    	material{txtBouteille1}
    }
    lathe{
    	cubic_spline
    	10,
    	<0.058000,0.452000>,
    	<0.018000,0.450000>,
    	<0.000000,0.480000>,
    	<0.011000,0.713000>,
    	<0.040000,0.740000>,
    	<0.080000,0.710000>,
    	<0.080000,0.480000>,
    	<0.058000,0.452000>,
    	<0.018000,0.450000>,
    	<0.000000,0.480000>
    	material{txtLiquide1}
    }
    object{Bouchon scale 0.03}
}
//------------------------------------------
// Bottle 2
//------------------------------------------

#declare Bouteille2 = union{
    lathe{
    	cubic_spline
    	26,
    	<0.038000,0.040000>,
    	<0.032000,0.024000>,
    	<0.040000,0.004000>,
    	<0.051000,0.013000>,
    	<0.046000,0.023000>,
    	<0.050000,0.040000>,
    	<0.041000,0.065000>,
    	<0.040000,0.140000>,
    	<0.050000,0.270000>,
    	<0.100000,0.390000>,
    	<0.110000,0.510000>,
    	<0.110000,0.720000>,
    	<0.070000,0.760000>,
    	<0.040000,0.760000>,
    	<0.010000,0.720000>,
    	<0.040000,0.750000>,
    	<0.070000,0.750000>,
    	<0.100000,0.720000>,
    	<0.100000,0.510000>,
    	<0.090000,0.390000>,
    	<0.040000,0.270000>,
    	<0.030000,0.140000>,
    	<0.030000,0.054000>,
    	<0.038000,0.040000>,
    	<0.032000,0.024000>,
    	<0.040000,0.004000>
    	material{txtBouteille2}
    }
    lathe{
    	cubic_spline
    	12,
    	<0.016000,0.384000>,
    	<0.000000,0.418000>,
    	<0.002000,0.663000>,
    	<0.010000,0.715000>,
    	<0.038000,0.740000>,
    	<0.068000,0.741000>,
    	<0.093000,0.717000>,
    	<0.093000,0.509000>,
    	<0.086000,0.392000>,
    	<0.016000,0.384000>,
    	<0.000000,0.418000>,
    	<0.002000,0.663000>
    	material{txtLiquide2}
    }
    object{Bouchon scale 0.03}
}
//------------------------------------------
// Bottle 3
//------------------------------------------
#declare Bouteille3 = union{
    lathe{
    	cubic_spline
    	29,
    	<0.027000,0.040000>,
    	<0.032000,0.024000>,
    	<0.031000,0.004000>,
    	<0.044000,0.008000>,
    	<0.041000,0.021000>,
    	<0.046000,0.036000>,
    	<0.039000,0.045000>,
    	<0.042000,0.088000>,
    	<0.054000,0.120000>,
    	<0.082000,0.162000>,
    	<0.069000,0.219000>,
    	<0.108000,0.298000>,
    	<0.090000,0.428000>,
    	<0.110000,0.720000>,
    	<0.070000,0.760000>,
    	<0.040000,0.760000>,
    	<0.010000,0.720000>,
    	<0.040000,0.750000>,
    	<0.070000,0.750000>,
    	<0.100000,0.720000>,
    	<0.074000,0.434000>,
    	<0.092000,0.297000>,
    	<0.052000,0.221000>,
    	<0.065000,0.168000>,
    	<0.035000,0.115000>,
    	<0.029000,0.084000>,
    	<0.027000,0.040000>,
    	<0.032000,0.024000>,
    	<0.031000,0.004000>
    	material{txtBouteille3}
    }
    lathe{
    	cubic_spline
    	12,
    	<0.003000,0.705000>,
    	<0.036000,0.744000>,
    	<0.065000,0.741000>,
    	<0.091000,0.719000>,
    	<0.066000,0.434000>,
    	<0.086000,0.296000>,
    	<0.076000,0.286000>,
    	<0.012000,0.289000>,
    	<0.000000,0.331000>,
    	<0.003000,0.705000>,
    	<0.036000,0.744000>,
    	<0.065000,0.741000>
    	material{txtLiquide3}
    }
    object{Bouchon2 scale 0.03}
}

//------------------------------------------
// Bottle 4
//------------------------------------------
#declare Bouteille4i = 
lathe{
	cubic_spline
	32,
	<0.038000,0.040000>,
	<0.032000,0.024000>,
	<0.040000,0.004000>,
	<0.051000,0.013000>,
	<0.046000,0.023000>,
	<0.050000,0.040000>,
	<0.041000,0.065000>,
	<0.048000,0.108000>,
	<0.073000,0.223000>,
	<0.068000,0.269000>,
	<0.069000,0.288000>,
	<0.093000,0.316000>,
	<0.110000,0.376000>,
	<0.080000,0.533000>,
	<0.100000,0.730000>,
	<0.070000,0.760000>,
	<0.040000,0.760000>,
	<0.010000,0.720000>,
	<0.040000,0.750000>,
	<0.070000,0.750000>,
	<0.090000,0.730000>,
	<0.072000,0.530000>,
	<0.100000,0.375000>,
	<0.084000,0.320000>,
	<0.060000,0.294000>,
	<0.058000,0.266000>,
	<0.061000,0.228000>,
	<0.038000,0.118000>,
	<0.030000,0.054000>,
	<0.038000,0.040000>,
	<0.032000,0.024000>,
	<0.040000,0.004000>
}
#declare Bouteille4=union{

	difference{
		object{Bouteille4i}
		cylinder{-z,0,0.08 translate y*0.38}
		material{txtBouteille4}
	}
	intersection{
		object{Bouteille4i}
		cylinder{-z,0,0.08 translate y*0.38}
		texture{txtEtiquetteBouteille4}
	}

	difference{
		lathe{
			cubic_spline
			15,
			<0.000000,0.267000>,
			<0.000000,0.396000>,
			<0.000000,0.542000>,
			<0.000000,0.707000>,
			<0.038000,0.743000>,
			<0.064000,0.744000>,
			<0.081000,0.716000>,
			<0.066000,0.529000>,
			<0.090000,0.375000>,
			<0.076000,0.322000>,
			<0.054000,0.296000>,
			<0.043000,0.261000>,
			<0.000000,0.267000>,
			<0.000000,0.396000>,
			<0.000000,0.542000>
		}
		plane{y,0.3}
		material{txtLiquide4}
	}
	object{Bouchon4 scale 0.03}
}
