//==========================================
// Jar, eggs and dairy bottle to be used with frige.pov
//==========================================
// Copyright(c) Gilles Tran 2001            
// http://www.oyonale.com
// Feel free to use and modify
//==========================================
// Made for Persistence of vision 3.5
//==========================================  

//------------------------------------------
// textures
//------------------------------------------
#declare txtEtiquettePot=texture{
        pigment {White}                           
        normal {bumps .4}        
        finish {ambient 0 diffuse 0.6 specular 0.2}
}
#declare txtPot=material{
        texture{pigment{rgbf<0.9,0.9,0.9,1>} finish{ambient 0 diffuse 0 specular 0.4 roughness 0.0001}}
        interior{ior 1.3}
}
#declare txtCouverclePot=texture{
        pigment{
                average
                pigment_map{
                        [1 gradient x color_map{[0.5 White][0.5 Red]}]
                        [1 gradient z color_map{[0.5 White][0.5 Red]}]
                }
        }                        
        finish{ambient 0.3 diffuse 0.6 specular 0.3 roughness 0.01 reflection 0.1}
        translate <130,0,130>
        scale 1.5
}
#declare txtCouverclePotHexa=texture{
        pigment{
                average
                pigment_map{
                        [1 gradient x color_map{[0.5 White][0.5 rgb <1,0,1>]}]
                        [1 gradient z color_map{[0.5 White][0.5 rgb <1,1,0>]}]
                }
        }                        
        finish{ambient 0.3 diffuse 0.6 specular 0.3 roughness 0.01 reflection 0.1}
        translate <130,0,130>
        scale 1.5
}
#declare txtInterieurPot=texture{
        #declare colConf=rgbf<1,0.5,0.3,0.2>;
        #declare colConf2=rgbf<1,0.5,0.3,1>;
        pigment{
                gradient y
                pigment_map{
                        [0 bozo color_map{[0 colConf*0.2][1 colConf2*0.5]} scale 1/9]
                        [0.5 bozo turbulence 0.2 lambda 3 color_map{[0 colConf*0.5][1 colConf2]} scale 1/9]
                        [0.6 bozo turbulence 0.4 lambda 3 color_map{[0.4 Clear][0.5 colConf2*1.2]} scale 1/9]
                        [0.8 bozo turbulence 1 lambda 5 color_map{[0.5 Clear][0.7 colConf2*1.2]} scale 1/9]
                        [0.9 color Clear]
                        [1 color Clear]
                }
        }                
        finish{ambient 0.3 diffuse 0.6 specular 0.3 roughness 0.01}
}        
#declare txtInterieurPotHexa=texture{
        #declare colConf=rgbf<0.7,0.2,0.9,0>*0.5;
        #declare colConf2=rgbf<0.7,0.2,0.9,1>*0.5;
        pigment{
                gradient y
                pigment_map{
                        [0 color colConf]
                        [0.2 color colConf]
                        [0.4 bozo turbulence 0.4 lambda 3 color_map{[0.4 Clear][0.5 colConf2]} scale 1/9]
                        [0.7 bozo turbulence 1 lambda 5 color_map{[0.5 Clear][0.7 colConf2]} scale 1/9]
                        [0.8 color Clear]
                        [1 color Clear]
                }
        }                
        finish{ambient 0.3 diffuse 0.6 specular 0.3 roughness 0.01}
        rotate y*157
}        
#declare txtOeuf = texture{   
        pigment {color rgb <0.8392, 0.7372, 0.6705>*1.5}   
        normal {wrinkles 0.083}   
        finish {ambient 0 diffuse 0.8 phong 0.064 phong_size 15 specular 0.050 roughness 0.1428}   
}
#declare txtOeufsSupport=texture{                
        pigment{White}
        finish{ambient 0 diffuse 0.8 specular 0.1 roughness 0.1}
}

//------------------------------------------
// Egg
//------------------------------------------
#declare Oeuf=union {
        isosurface {
            function {sqrt(pow(x+1,2)+pow(y-1,2)+pow(z,2))+2*sqrt(pow(x-1,2)+ pow(y+1,2)+ pow(z,2))-5}
            max_gradient 30
            contained_by {sphere {0,10}}
            rotate -z*45
            translate y*2.15
        }
        texture {txtOeuf scale 0.1}
}
#declare Oeufs=union{
        #declare SupportOeuf=cylinder{0,y*2,5}
        #declare i=0;
        #declare rd=seed(0);
        #while(i<6)
                union{
                        object{SupportOeuf}
                        object{Oeuf scale (1.1-rand(rd)*0.1)*4 rotate x*rand(rd)*5 rotate y*360*rand(rd)}
                        translate x*i*5*cos(pi/4)*2
                        #if (mod(i,2)=0)
                                translate z*2*5*cos(pi/4)
                        #end
                        
                }
                #declare i=i+1;
        #end
        texture{txtOeufsSupport}
        translate x*5
        scale <-1,1,1>
}

//------------------------------------------
// Hexagonal jar with jam texture
//------------------------------------------
#declare PotHexa=union{
        difference{
                merge{
                        torus{4.7,0.1 translate y*12}
                        torus{4.7,0.1 rotate z*5 translate y*12.3}
                        cylinder{0,y,4.7 translate y*11.7}
                }          
                cylinder{y*1.5,y*13,4.1}                  
                material{txtPot}
        }
        difference{
                merge{
                        cylinder{y,y*11,5}
                        torus{4,1 translate y*1}
                        torus{4,1 translate y*11}
                        material{txtPot}
                }    
                merge{                     
                        cylinder{y*1.5,y*13,4.1}
                        torus{5,0.2 translate y}
                        torus{5,0.2 translate y*11}
                        #declare i=0;#while(i<360) 
                                box{<-3,-1,-2>,<3,12,0> translate z*-4.8 rotate y*i} 
                                sphere{0,1 scale <1,5,0.4> translate <0,6,-5>  rotate y*i}
                        #declare i=i+36;#end
                        texture{txtInterieurPotHexa scale 14}
                }
        }
        
        difference{
                union{cylinder{0,y,5.1} cylinder{0,y*(1+0.3*1.3),4.8} torus{4.8,0.3 scale <1,1.3,1> translate y}} 
                #declare i=0;#while(i<360) box{<-3,-1,-2>,<3,2,0> translate z*-5 rotate y*i} #declare i=i+36;#end
                scale <1,0.7,1>
                texture{txtCouverclePotHexa}
                rotate x*2
                translate y*12.3
        }

}                   

//------------------------------------------
// Milk bottle
//------------------------------------------
#declare e=0.3;
#declare n=0.3;                                  
#declare txtBoutLait=texture{
        pigment{image_map{jpeg "meuh.jpg" map_type 2}}
        finish{ambient 0 diffuse 1 specular 0.2 roughness 0.1 reflection 0.1}
        rotate y*-30
}
#declare txtCapsuleLait=texture{
        pigment{Red}
        normal{wrinkles 0.3 scale 0.5}
        finish{ambient 0 diffuse 0.8 specular 1 roughness 0.001 metallic brilliance 10 reflection {0.2 metallic}}
}
#declare BoutLait=union{
        union{
                cylinder{0,y,1}
                torus{0.8,0.2}
                torus{0.7,0.3 translate y}
                difference{
                        cylinder{0,y*0.1,0.5}
                        plane{z,0 inverse}
                        scale <1,1,4>
                        rotate x*-75
                        translate -z*0.8
                        translate y*0.4
                }
                scale <2.5,0.7,2.5>
                texture{txtCapsuleLait}
                translate y*28
        }
        isosurface{
            // this isosurface morphs an ellipsoid into a cylinder
         	function {(pow(pow(abs(x),2/e)+pow(abs(2*y-1),2/e),e/n)+pow(abs(z),2/n)-1)*(1-y) + (x*x+z*z-0.2)*pow(y,3)}
        	contained_by { box { <-1,0,-1>, <1,1,1> } }
        	max_gradient 7
                texture{txtBoutLait}
        	scale <5,28,5>
        }
} 


  